/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import fuzs.betteranimationscollection.client.element.ModelElementBase;
import fuzs.betteranimationscollection.client.model.CatTailModel;
import fuzs.betteranimationscollection.client.model.OcelotTailModel;
import fuzs.betteranimationscollection.mixin.client.accessor.CatCollarLayerAccessor;
import fuzs.puzzleslib.client.core.ClientModConstructor;
import fuzs.puzzleslib.client.model.geom.ModelLayerRegistry;
import fuzs.puzzleslib.config.ValueCallback;
import fuzs.puzzleslib.config.core.AbstractConfigBuilder;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1451;
import net.minecraft.class_3680;
import net.minecraft.class_3684;
import net.minecraft.class_5601;
import net.minecraft.class_5605;

public class CatTailElement
extends ModelElementBase {
    public static int tailLength;
    public static int animationSpeed;
    private final class_5601 animatedCat;
    private final class_5601 animatedCatCollar;

    public CatTailElement(ModelLayerRegistry modelLayerRegistry) {
        this.animatedCat = modelLayerRegistry.register("animated_cat");
        this.animatedCatCollar = modelLayerRegistry.register("animated_cat", "collar");
    }

    @Override
    public String[] modelDescription() {
        return new String[]{"Takes away the stick tails of the current cats and gives them something nicer instead.", "Fully animated flowing tails that move while they stand or run, and even curl around their bodies when they sit."};
    }

    @Override
    void onRegisterAnimatedModels(ModelElementBase.AnimatedModelsContext context, ModelElementBase.EntityModelBakery bakery) {
        context.registerAnimatedModel(class_3680.class, () -> new CatTailModel(bakery.bakeLayer(this.animatedCat)), (renderLayerParent, renderLayer) -> {
            if (renderLayer instanceof class_3684) {
                ((CatCollarLayerAccessor)renderLayer).setCatModel(new CatTailModel<class_1451>(bakery.bakeLayer(this.animatedCatCollar)));
            }
            return Optional.empty();
        });
    }

    @Override
    public void onRegisterLayerDefinitions(ClientModConstructor.LayerDefinitionsContext context) {
        context.registerLayerDefinition(this.animatedCat, () -> OcelotTailModel.createAnimatedBodyMesh(class_5605.field_27715));
        context.registerLayerDefinition(this.animatedCatCollar, () -> OcelotTailModel.createAnimatedBodyMesh(new class_5605(0.01f)));
    }

    @Override
    public void setupModelConfig(AbstractConfigBuilder builder, ValueCallback callback) {
        callback.accept((Supplier)builder.comment("Define tail length.").defineInRange("tail_length", 15, 1, 15), v -> {
            tailLength = v;
        });
        callback.accept((Supplier)builder.comment("Animation swing speed for tail.").defineInRange("animation_speed", 7, 1, 20), v -> {
            animationSpeed = v;
        });
    }
}

